<?php

function my_styles_method() {
	wp_enqueue_style(
		'custom-style-css',
		get_stylesheet_directory_uri() . '/style.css'
	);
    
    $custom_css = load_styles();
    wp_add_inline_style( 'custom-style-css', $custom_css );
}
add_action( 'wp_enqueue_scripts', 'my_styles_method' );

function load_styles(){
$color1 = "#0b7c25";
$color2 = "#aae597";

$settings = wp_parse_args(
    get_option( 'generate_settings', array() ),
    generate_get_defaults()
);

// Background color.
$color3 = $settings['background_color'];

// Text color.
$settings['text_color'];

// Link color.
$color1 = $settings['link_color'];

// Link color hover.
$color2 = $settings['link_color_hover'];


ob_start();
?>
/* theme overrides */
.entry-header {display:none;}
.site-footer  .micro-format h2, .site-footer .micro-format span {color:#fff!important;}
.elementor-testimonial__image {display:none!important;}
.page-header-image {display:none;}
a, a:visited {color:<?php echo $color1?>!important;}
a:hover {color:<?php echo $color2?>!important;}

.maincolor {color:<?php echo $color1?>!important;}
.seccolor {color:<?php echo $color2?>!important;}
.background, .elementor-shape-fill {background-color:<?php echo $color1?>!important;fill:<?php echo $color1?>!important;-webkit-box-shadow: 2px 2px 5px rgba(0, 0, 0, 0.3);  -moz-box-shadow: 2px 2px 5px rgba(0, 0, 0, 0.3);  box-shadow: 2px 2px 5px rgba(0, 0, 0, 0.3);}
.background a, .background a:visited {color:<?php echo $color2?>!important;}
.shadow {-webkit-box-shadow: 2px 2px 5px rgba(0, 0, 0, 0.3);  -moz-box-shadow: 2px 2px 5px rgba(0, 0, 0, 0.3);  box-shadow: 2px 2px 5px rgba(0, 0, 0, 0.3);}

/* elementor */
.elementor-button, .elementor-button:visited {background-color:<?php echo $color1?>!important;color:#fff!important;}
.elementor-icon-list-icon i {color:<?php echo $color2?>!important;}
#topnav a,  #topnav a:visited {color:<?php echo $color3?>!important;}
#topnav a:hover, {color:<?php echo $color2?>!important;}

/* breadcrumbs */
.breadcrumbs span, .breadcrumbs * {font-size:13px;}

/* wpcf7 */
.wpcf7 input[type=email], .wpcf7 input[type=number], .wpcf7 input[type=password], .wpcf7 input[type=search], .wpcf7 input[type=tel], .wpcf7 input[type=text], .wpcf7 input[type=url], .wpcf7 select, .wpcf7 textarea {border: none;  border-bottom: 1px solid #ccc!important;
    width: 100%;background-color: #fff;}
.wpcf7 textarea {max-height:175px;}

/* background */
.background .wpcf7, .background h2 {padding:24px!important;}
.background .wpcf7 label {color:#fff;}
.background input[type=email], .background input[type=number],.background input[type=password],.background input[type=search],.background input[type=tel],.background input[type=text], .background input[type=url],.background select, .background textarea {border:none;padding:5px;}
.background textarea {max-height:125px;}
.background input[type=submit] {background-color:<?php echo $color2?>;color:#fff;margin-top:16px;}
.background .wpcf7 p {margin:0!important;}


/* grids */
.grid {display:grid;grid-template-columns:33% 33% 33% ;justify-items:center;grid-gap:20px;clear:both;}

.grid.reviews {grid-template-columns:50% 50% ;}
.grid.referenties {grid-template-columns:33% 33% 33%;grid-gap:0;}

/* subpage grid */
.subpage h4 {text-align:center;}

/* testimonial grid */
.review {width:100%;}
.review .description {background-color:#efefef;padding:24px;}
.review .shape {width: 0;   height: 0;   border-top: 24px solid #efefef;
   border-left: 24px solid transparent; border-right: 24px solid transparent;
   margin:0 auto 0 100px;}
.review .image {margin:16px auto 0 100px;max-width:50px;}
.review .image img {-webkit-border-radius: 50%;-moz-border-radius: 50%;border-radius:50%;}
.review .title {margin:16px auto 0 100px;max-width:240px;}

/* referentie grid */
.referentie {width:100%;padding:0px 10px;}
.referentie img {width:100%;}
.referentie .title {height:60px;}
.referentie .description p {margin:0;line-height:1em;font-size:90%;}
.referentie .title, .referentie .description {padding:5px;}

/* media queries */
@media only screen and (min-width : 1279px) {
       
}

@media only screen and (max-width : 1279px) {
   
}

@media only screen and (max-width : 979px) {
   
}

@media only screen and (max-width : 768px) {
 .grid.referenties {grid-template-columns:100%;grid-gap:0;}
 .grid.reviews {grid-template-columns:100% ;}
 .grid.children {grid-template-columns:100% ;}
}

@media only screen and (max-width : 480px) {
    #topnav {display:none!important;}
   	
}

<?php
$sc = ob_get_contents();
ob_end_clean();
		
return $sc;
}