<?php
/**
 * GeneratePress child theme functions and definitions.
 *
 * Add your custom PHP in this file. 
 * Only edit this file if you have direct access to it on your server (to fix errors if they happen).
 */

function generatepress_child_enqueue_scripts() {
	if ( is_rtl() ) {
		wp_enqueue_style( 'generatepress-rtl', trailingslashit( get_template_directory_uri() ) . 'rtl.css' );
	}
}
add_action( 'wp_enqueue_scripts', 'generatepress_child_enqueue_scripts', 100 );

//hide wptc
function custom_menu_page_removing() {
    remove_menu_page( 'wp-time-capsule-monitor' );
}
add_action( 'admin_menu', 'custom_menu_page_removing' );


//change login logo
function my_login_logo() { ?>
    <style type="text/css">
        #login h1 a, .login h1 a {
        background-image: url(<?php echo get_stylesheet_directory_uri() ?>/logo.jpg);
		max-height:50px;
		width:100%;
		background-size: contain;
        }
        
        #login h1 {background-color:#fff;padding:10px;margin-bottom:10px;}
    </style>
<?php }
add_action( 'login_enqueue_scripts', 'my_login_logo' );

//add fancybox
add_action( 'wp_enqueue_scripts', 'mailbox_enqueue_frontend' );

function mailbox_enqueue_frontend() {
wp_register_script('JQfancyS','https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.3.5/jquery.fancybox.min.js');
wp_enqueue_script( 'JQfancyS');

wp_register_style('JQfancyC', 'https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.3.5/jquery.fancybox.min.css');
wp_enqueue_style( 'JQfancyC');

//wp_deregister_script( 'JQfancyS' );
//wp_deregister_style('JQfancyC');
}
//add inline styles + custom post types
require_once('styles.php' );
require_once('cpt.php' );

//custom media formats
add_action( 'after_setup_theme', 'wpdocs_theme_setup' );
function wpdocs_theme_setup() {
    add_image_size( 'sherlock', 500, 375, true ); // (cropped)
}


//add svg support
function cc_mime_types($mimes) {
 $mimes['svg'] = 'image/svg+xml';
 return $mimes;
}

add_filter('upload_mimes', 'cc_mime_types');

//hide admin panel
add_filter('show_admin_bar', '__return_false');

//custom content filter
add_filter( 'th_awesome_text', 'wptexturize'       );
add_filter( 'th_awesome_text', 'convert_smilies'   );
add_filter( 'th_awesome_text', 'convert_chars'     );
add_filter( 'th_awesome_text', 'wpautop'           );
add_filter( 'th_awesome_text', 'shortcode_unautop' );
add_filter( 'th_awesome_text', 'do_shortcode'      );


//gets a list of referenties
add_shortcode('referenties', 'mailbox_referenties');
function mailbox_referenties($atts) { 

$atts = shortcode_atts(array(
            'qty' => '3',
            'search' => '',
            'view' => '1',
 ), $atts);
 
$args = array(
    'post_type'      => 'referentie',
    'posts_per_page' => $atts["qty"],
    'order'          => 'ASC',
    'orderby'        => 'rand',
    'post_status'    => 'publish',
	's'              => '',
);


$parent = new WP_Query( $args );

ob_start();	

if ( $parent->have_posts() ) : 

    echo "<div class='grid referenties'>";
    while ( $parent->have_posts() ) : $parent->the_post();
		$image = get_the_post_thumbnail(get_the_id(),'medium')[0];
		$image2 = get_the_post_thumbnail_url(get_the_ID(),'large'); 
        ?>
        <div class="referentie">
            <div class="title"><h3><?php echo the_title();?></h3></div>
            <div class="image"><a href="<?php echo $image2?>" data-fancybox="gallery"><?php echo get_the_post_thumbnail( get_the_id(), 'thumbnail' ); ?></a></div>
             <div class="description"><?php echo the_content();?></div>
        </div>
        <?php
    endwhile;
    echo "</div>";

endif; 
wp_reset_postdata(); 
$sc = ob_get_contents();
ob_end_clean();
return $sc;
 
}

//gets a list of testimonials
add_shortcode('testimonials', 'mailbox_testimonials');
function mailbox_testimonials($atts) { 

$atts = shortcode_atts(array(
            'qty' => '3',
            'search' => '',
            'view' => '1',
 ), $atts);
 
$args = array(
    'post_type'      => 'testimonial',
    'posts_per_page' => $atts["qty"],
    'order'          => 'ASC',
    'orderby'        => 'rand',
    'post_status'    => 'publish',
	's'              => '',
 );


$parent = new WP_Query( $args );

ob_start();	

if ( $parent->have_posts() ) : 

    echo "<div class='grid reviews'>";
    while ( $parent->have_posts() ) : $parent->the_post();
		$image = get_the_post_thumbnail(get_the_id(),'thumbnail')[0];
        ?>
        <div class="review">
            <div class="description"><?php echo the_content();?></div>
            <div class="shape"></div>
            <div class="image"><?php echo get_the_post_thumbnail( get_the_id(), 'thumbnail' ); ?></div>
            <div class="title"><h4><?php echo the_title();?></h4></div>
           
        </div>
        <?php
    endwhile;
    echo "</div>";

endif; 
wp_reset_postdata(); 
$sc = ob_get_contents();
ob_end_clean();
return $sc;
 
}


//gets a list of subpages
add_shortcode('children', 'mailbox_subpages');
function mailbox_subpages() { 
 
$args = array(
    'post_type'      => 'page',
    'posts_per_page' => -1,
    'post_parent'    => get_the_id(),
    'order'          => 'ASC',
    'orderby'        => 'menu_order'
 );


$parent = new WP_Query( $args );

ob_start();	

if ( $parent->have_posts() ) { 

    echo "<div class='grid children'>";
    while ( $parent->have_posts() ) : $parent->the_post();
        //$image_id = get_post_thumbnail_id(get_the_id(),'thumbnail');
		//$image = wp_get_attachment_url($image_id);
		
		//$image = get_the_post_thumbnail(get_the_id(),'medium')[0];
		$image = get_the_post_thumbnail_url(get_the_ID(),'sherlock'); 
        ?>
        <div class="subpage" style="width:100%;">
            <a href="<?php echo get_permalink(get_the_id()) ?>">
            <div class="image" style="width:100%;"><img style="width:100%;" src="<?php echo $image  ?>" /></div>
            <div class="title"><h4><?php echo the_title();?></h4></div>
            </a>
        </div>
        <?php
    endwhile;
    echo "</div>";
}
else {
    ?>
    <style>
        .diensten {display:none;}
    </style>
    <?php
}

wp_reset_postdata(); 
$sc = ob_get_contents();
ob_end_clean();
return $sc;
 
}
 
//breadcrumbs navxt shortcode
add_shortcode('breadcrumbs', 'mailbox_show_breadcrumbs');
function mailbox_show_breadcrumbs($atts, $content = ''){

if (!is_front_page()) {
ob_start();	 
?>
<div class="breadcrumbs" typeof="BreadcrumbList" vocab="http://schema.org/">
    <?php if(function_exists('bcn_display'))
    {
        bcn_display();
    }?>
</div>
<?php
$sc = ob_get_contents();
ob_end_clean();
		
return $sc;
}
}


//show the content - used in elementor templates
add_shortcode('content', 'mailbox_show_content');
function mailbox_show_content($atts, $content = ''){

$atts = shortcode_atts(array(
            'post_type' => 'post',
            'category' => '',
     'width' => '33%',
 ), $atts);
		
ob_start();	
echo the_content();
$sc = ob_get_contents();
ob_end_clean();
		
return $sc;
}