<?php
/**
 * Plugin Name: Management of Micro-Formats in a Wordpress Installation
 * Plugin URI:  http://www.gnu.org/copyleft/gpl.html
 * Description: helps in the management of HTML5 microformats
 * Version: 1.7
 * Author: Bart
 * Author URI:  http://www.gnu.org/copyleft/gpl.html
 * License: GPL2
 * Text Domain: mailbox-micro-formats
 * Domain Path: /languages/
 */

 /*  Copyright YEAR  PLUGIN_AUTHOR_NAME  (email : PLUGIN AUTHOR EMAIL)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/


$version = "1.7";
add_filter('widget_text', 'do_shortcode');
update_option("MAILBOX_MICRO_FORMATS_VERSION_KEY", $version);
update_option("MAILBOX_MICRO_FORMATS_NAME","Microformats");
$mailbox_micro_formats_css_url = plugins_url() .  "/mailbox-micro-formats/includes/css/mailbox_micro_formats.css";

//load textdomain for translations
function mailbox_micro_formats_load_plugin_textdomain() {
  load_plugin_textdomain( 'mailbox-micro-formats', FALSE, basename( dirname( __FILE__ ) ) . '/languages/' );
}
add_action( 'init', 'mailbox_micro_formats_load_plugin_textdomain' );

//activation hook
function mailbox_micro_formats_myplugin_activate() {
  add_option('mailbox_micro_formats_opening_hours', '09-18');
  add_option('add_bio', '0');
  add_option('mailbox_micro_formats_include_weekend', '0');
}
register_activation_hook( __FILE__, 'mailbox_micro_formats_myplugin_activate' );

//deactivation hook
function mailbox_micro_formats_myplugin_deactivate() {
    unregister_setting( 'mailbox_micro_formats', 'organization' );
	unregister_setting( 'mailbox_micro_formats', 'url' );
	unregister_setting( 'mailbox_micro_formats', 'email' );
	unregister_setting( 'mailbox_micro_formats', 'telephone' );
	unregister_setting( 'mailbox_micro_formats', 'logo' );
	unregister_setting( 'mailbox_micro_formats', 'vat' );
	unregister_setting( 'mailbox_micro_formats', 'street' );
	unregister_setting( 'mailbox_micro_formats', 'zip' );
	unregister_setting( 'mailbox_micro_formats', 'locality' );
	unregister_setting( 'mailbox_micro_formats', 'country' );
	unregister_setting( 'mailbox_micro_formats', 'description' );
	unregister_setting( 'mailbox_micro_formats', 'add_bio' );
	unregister_setting( 'mailbox_micro_formats', 'kml_map' );
	unregister_setting( 'mailbox_micro_formats', 'mailbox_micro_formats_opening_hours' );
	unregister_setting( 'mailbox_micro_formats', 'mailbox_micro_formats_include_weekend' );
}
register_deactivation_hook( __FILE__, 'mailbox_micro_formats_myplugin_deactivate' );


//include admin functions & includes
include_once dirname( __FILE__ ) .'/admin/admin.php'; //admin section
include_once dirname( __FILE__ ) .'/includes/functions.php'; //functions
include_once dirname( __FILE__ ) .'/includes/rich-snippets.php'; //rich snippets







